<?php

$app = $this->app;

return [
    'name' => 'singleton',
    'label' => 'Singleton',
    'icon' => 'content:assets/icons/singleton.svg',
    'group' => 'Content',
    'data' => function() use($app) {

        $singletons = array_filter($app->module('content')->models(), fn($model) => $model['type'] == 'singleton');
        $options = [];

        foreach ($singletons as $singleton) {

            $options[] = [
                'value' => $singleton['name'],
                'label' => $singleton['label'] ? $singleton['label'] : $singleton['name'],
            ];
        }

        return [
            [
                'name' => 'singleton',
                'type' => 'select',
                'info' => 'Content singleton to connect to',
                'opts' => [
                    'options' => $options
                ],
                'group' => 'Singleton',
                'required' => true
            ],
            [
                'name' => 'catchSubSlugs',
                'type' => 'boolean',
                'label' => 'Catch Sub-Slugs',
                'info' => 'Catch all sub routes',
                'opts' => [
                    'default' => false
                ],
                'group' => 'Singleton'
            ],

            [
                'name' => 'layout',
                'type' => 'set',
                'label' => 'Layout',
                'info' => 'Additional layout components to display before and after singleton content',
                'i18n' => true,
                'group' => 'Layout',
                'opts' => [
                    'fields' =>  [
                        [
                            'name' => 'before',
                            'type' => 'layout',
                            'label' => 'Before',
                            'info' => 'Layout before',
                        ],
                        [
                            'name' => 'after',
                            'type' => 'layout',
                            'label' => 'After',
                            'info' => 'Layout after',
                        ]
                    ]
                ]
            ],
        ];
    },

    'resolve' => function($page, array $options = []) use($app) {

        $singleton = $page['data']['singleton'] ?? null;
        $catchSubSlugs = $page['data']['catchSubSlugs'] ?? false;

        if (!$singleton || !$app->module('content')->exists($singleton) || !$catchSubSlugs) {
            return false;
        }

        $page['data']['data'] = $app->module('content')->item($singleton);
        $page['data']['params'] = $options['params'] ?? null;

        // fix content populate
        unset(
            $page['data']['data']['_model'],
            $page['data']['data']['_id']
        );

        return $page;
    },

    'process' => function($page, $locale = 'default', $options = []) use ($app) {

        $singleton = $page['data']['singleton'] ?? null;

        if (!$singleton || !$app->module('content')->exists($singleton)) {
            return $page;
        }

        if (isset($page['data']['data'])) {
            return $page;
        }

        $page['data']['data'] = $app->module('content')->item($singleton);
        $page['data']['params'] = $options['params'] ?? null;

        // fix content populate
        unset(
            $page['data']['data']['_model'],
            $page['data']['data']['_id']
        );

        return $page;
    }
];