<kiss-container class="kiss-margin-small">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/lokalize/projects')?>"><?=t('Lokalize')?></a></li>
    </ul>

    <vue-view>

        <template>

            <div class="kiss-margin-large-bottom kiss-size-4 kiss-text-bold">
                <?=t('Projects')?>
            </div>

            <app-loader v-if="loading"></app-loader>

            <div v-if="projects && projects.length">

                <div class="kiss-margin">
                    <input type="text" class="kiss-input" :placeholder="t('Filter projects...')" v-model="filter">
                </div>

                <kiss-card class="kiss-margin-small kiss-flex kiss-flex-middle animated fadeIn" theme="shadowed contrast" hover="shadow bordered-primary" gap="small" v-for="project in filtered">
                    <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                        <canvas width="40" height="40"></canvas>
                        <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                            <div :style="{color: project.color || 'inherit' }"><kiss-svg :src="$baseUrl(project.icon || 'lokalize:icon.svg')" width="30" height="30"></kiss-svg></div>
                        </div>
                        <a class="kiss-cover" :href="$routeUrl(`/lokalize/projects/project/${project.name}`)"></a>
                    </div>
                    <div class="kiss-padding-small">
                        <a class="kiss-text-bold kiss-link-muted" :href="$routeUrl(`/lokalize/projects/project/${project.name}`)" :aria-label="project.name" kiss-tooltip="right">{{ project.label || project.name}}</a>
                    </div>
                    <div class="kiss-flex-1"></div>
                    <div class="kiss-padding-small kiss-size-small kiss-color-muted kiss-visible@l">{{ project.info }}</div>
                    <div class="kiss-padding-small kiss-align-right kiss-size-small kiss-margin-start">{{ project.status._overall }}%</div>
                    <div class="kiss-padding-small">
                        <a @click="toggleProjectActions(project)"><icon>more_horiz</icon></a>
                    </div>
                </kiss-card>

            </div>

            <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted" v-if="projects && (!projects.length || !filtered.length)">
                <div>
                    <kiss-svg :src="$baseUrl('lokalize:icon.svg')" width="40" height="40"></kiss-svg>
                    <p class="kiss-size-large kiss-margin-small-top"><?=t('No projects')?></p>
                </div>
            </div>

            <app-actionbar>

                <kiss-container>
                    <div class="kiss-flex kiss-flex-middle">
                        <div v-if="groups.length">
                            <span class="kiss-text-caption kiss-color-muted"><?=t('group')?></span>
                            <div class="kiss-margin-xsmall-top kiss-display-block kiss-overlay-input">
                                <div class="kiss-size-4" :class="{'kiss-color-muted': !group, 'kiss-text-bold': group}">{{ group || t('All groups') }}</div>
                                <select v-model="group">
                                    <option :value="null">{{t('All')}}</option>
                                    <option :selected="group == name" v-for="name in groups">{{ name }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="kiss-flex-1"></div>
                        <a class="kiss-button kiss-button-primary" href="<?=$this->route('/lokalize/projects/create')?>"><?=t('Create project')?></a>
                    </div>
                </kiss-container>

            </app-actionbar>

            <kiss-popout :open="actionProject && 'true'" @popoutclose="toggleProjectActions(null)">
                <kiss-content>
                        <kiss-navlist v-if="actionProject">
                            <ul>
                                <li class="kiss-nav-header">{{ actionProject.label || actionProject.name }}</li>
                                <li>
                                    <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/lokalize/projects/edit/${actionProject.name}`)">
                                        <icon class="kiss-margin-small-end">create</icon>
                                        <?=t('Edit')?>
                                    </a>
                                </li>
                                <li class="kiss-nav-divider"></li>
                                <li>
                                    <a class="kiss-color-danger kiss-flex kiss-flex-middle" @click="remove(actionProject)">
                                        <icon class="kiss-margin-small-end">delete</icon>
                                        <?=t('Delete')?>
                                    </a>
                                </li>
                            </ul>
                        </kiss-navlist>
                </kiss-content>
            </kiss-popout>

        </template>

        <script type="module">

            export default {

                data() {
                    return {
                        projects: null,
                        group: null,
                        filter: '',
                        loading: false,
                        actionProject: null
                    }
                },

                mounted() {
                    this.load()
                },

                computed: {

                    filtered() {

                        let projects = [];

                        (this.projects || []).forEach(p => {

                            if (this.filter && !`${p.name} ${p.label || ''}`.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return;
                            }

                            if (this.group && p.group != this.group ) return;
                            projects.push(p)
                        });

                        return projects;
                    },

                    groups() {
                        let groups = [];

                        (this.projects || []).forEach(p => {
                            if (!p.group || groups.indexOf(p.group) > -1) return;
                            groups.push(p.group);
                        });

                        return groups.sort();
                    }
                },

                methods: {

                    load() {

                        this.loading = true;

                        this.$request('/lokalize/projects/load', {options:{}}).then(projects => {

                            this.projects = projects;
                            this.loading = false;
                        });
                    },

                    remove(project) {

                        App.ui.confirm('Are you sure?', () => {

                            this.$request('/lokalize/projects/remove', {project}).then(res => {
                                this.projects.splice(this.projects.indexOf(project), 1);
                            });
                        });
                    },

                    toggleProjectActions(project) {

                        if (!project) {
                            setTimeout(() => this.actionProject = null, 300);
                            return;
                        }

                        this.actionProject = project;
                    }
                }
            }

        </script>

    </vue-view>


</kiss-container>
