export default {

    data() {
        return {
            val: this.modelValue,
            showActionsPopout: false,
            ready: false,
            actions: [],
        }
    },

    props: {
        modelValue: {
            default: null
        },
        field: {
            type: Array,
            default: []
        },
        document: {
            type: Object,
            default: null
        },
        locale: {
            type: String,
            default: null
        },
    },

    computed: {
        isSupported() {
            return this.modelValue && !this.field.multiple && ['text', 'wysiwyg', 'html'].includes(this.field.type);
        }
    },

    watch: {
        modelValue() {
            this.val = this.modelValue;
        }
    },

    methods: {
        translate() {

            VueView.ui.modal('lokalize:assets/dialog/i18n-chooser.js', {
                locale: this.locale
            }, {
                onSelect: (selected) => {

                    if (!selected) return;

                    App.ui.block();

                    this.$request('/lokalize/utils/translate', {
                        text: this.modelValue,
                        to: selected
                    }).then(rsp => {

                        if (rsp.error) {
                            console.log(rsp.error);
                            return;
                        }

                        if (rsp.translation && !rsp.translation.error) {
                            this.$emit('update:modelValue', rsp.translation)
                        }

                    }).finally(() => {
                        App.ui.unblock();
                    });
                }
            });
        }
    },

    template: /*html*/`
        <div v-if="isSupported">
            <button type="button" class="kiss-input-blank kiss-cursor-pointer kiss-flex kiss-flex-middle" :aria-label="t('Translate text')" kiss-tooltip="bottom-right" @click="translate()">
                <kiss-svg :src="$baseUrl('lokalize:icon.svg')" width="1em"><canvas width="1em" height="1em"></canvas></kiss-svg>
            </button>
        </div>
    `
}
