export function parseCSV(csvContent) {

    const rows = [];
    let currentRow = [];
    let currentCell = "";
    let insideQuotes = false;

    for (let i = 0; i < csvContent.length; i++) {
        const char = csvContent[i];
        const nextChar = csvContent[i + 1];

        // Handle quotes
        if (char === '"') {
            if (insideQuotes && nextChar === '"') {
                // Escaped quote (double quote)
                currentCell += '"';
                i++; // Skip the next quote
            } else {
                // Toggle quote state
                insideQuotes = !insideQuotes;
            }
        }
        // Handle commas
        else if (char === ',' && !insideQuotes) {
            // End of cell
            currentRow.push(currentCell);
            currentCell = "";
        }
        // Handle newlines
        else if ((char === '\n' || (char === '\r' && nextChar === '\n')) && !insideQuotes) {
            // End of row
            currentRow.push(currentCell);
            rows.push(currentRow);
            currentRow = [];
            currentCell = "";

            // Skip the \n if we just processed \r
            if (char === '\r') {
                i++;
            }
        }
        // All other characters
        else {
            currentCell += char;
        }
    }

    // Handle the last cell and row
    if (currentCell || currentRow.length > 0) {
        currentRow.push(currentCell);
        rows.push(currentRow);
    }

    return rows;
}
