
<kiss-container class="kiss-margin" size="medium">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/system')?>"><?=t('Settings')?></a></li>
    </ul>

    <vue-view>

        <template>

            <div class="kiss-margin-large-bottom kiss-size-4 kiss-text-bold">
                <?=t('Templates')?>
            </div>

            <app-loader v-if="loading"></app-loader>

            <div v-if="templates && templates.length">

                <div class="kiss-margin">
                    <input type="text" class="kiss-input" :placeholder="t('Filter templates...')" v-model="filter">
                </div>

                <div class="app-list-items animated fadeIn">

                    <kiss-card class="kiss-margin-small kiss-flex kiss-flex-middle animated fadeIn" gap="small" theme="shadowed contrast" hover="shadow bordered-primary" v-for="(template, idx) in filtered">
                        <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                            <canvas width="40" height="40"></canvas>
                            <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                                <div :style="{color: template.color || 'inherit' }"><kiss-svg :src="$baseUrl(template.icon || 'layout:icon.svg')" width="30" height="30"></kiss-svg></div>
                            </div>
                            <a class="kiss-cover" :href="$routeUrl('/layout-components/templates/template/'+template._id)"></a>
                        </div>
                        <div class="kiss-padding-small kiss-size-5 kiss-flex-1 kiss-position-relative">
                            <strong>{{template.name}}</strong>
                            <a class="kiss-cover" :href="$routeUrl('/layout-components/templates/template/'+template._id)"></a>
                        </div>
                        <a class="kiss-padding-small" @click="toggleTemplateActions(template)"><icon>more_horiz</icon></a>
                    </kiss-card>

                </div>

            </div>

            <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted" v-if="templates && (!templates.length || !filtered.length)">
                <div>
                    <kiss-svg :src="$baseUrl('layout:icon.svg')" width="60" height="60"></kiss-svg>
                    <p class="kiss-size-large kiss-margin-small-top"><?=t('No templates')?></p>
                </div>
            </div>

            <teleport to="body">

                <app-actionbar>

                    <kiss-container size="medium">
                        <div class="kiss-flex kiss-flex-middle">
                            <div v-if="groups.length">
                                <span class="kiss-text-caption kiss-color-muted"><?=t('Group')?></span>
                                <div class="kiss-margin-xsmall-top kiss-display-block kiss-overlay-input">
                                    <div class="kiss-size-4" :class="{'kiss-color-muted': !group, 'kiss-text-bold': group}">{{ group || t('All layouts') }}</div>
                                    <select v-model="group">
                                        <option :value="null">{{t('All')}}</option>
                                        <option :selected="group == name" v-for="name in groups" :value="name">{{ name  }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="kiss-flex-1"></div>
                            <a class="kiss-button kiss-button-primary" href="<?=$this->route('/layout-components/templates/template')?>"><?=t('Add template')?></a>
                        </div>
                    </kiss-container>

                </app-actionbar>

                <kiss-popout :open="actionTemplate && 'true'" @popoutclose="toggleTemplateActions(null)">
                    <kiss-content>
                            <kiss-navlist v-if="actionTemplate">
                                <ul>
                                    <li class="kiss-nav-header">{{ actionTemplate.name }}</li>
                                    <li>
                                        <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/layout-components/templates/template/${actionTemplate._id}`)">
                                            <icon class="kiss-margin-small-end">edit</icon>
                                            {{ t('Edit') }}
                                        </a>
                                    </li>
                                    <li>
                                        <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/layout-components/templates/clone/${actionTemplate._id}`)">
                                            <icon class="kiss-margin-small-end">control_point_duplicate</icon>
                                            {{ t('Clone') }}
                                        </a>
                                    </li>
                                    <li class="kiss-nav-divider"></li>
                                    <li>
                                        <a class="kiss-color-danger kiss-flex kiss-flex-middle" @click="remove(actionTemplate)">
                                            <icon class="kiss-margin-small-end">delete</icon>
                                            {{ t('Delete') }}
                                        </a>
                                    </li>
                                </ul>
                            </kiss-navlist>
                    </kiss-content>
                </kiss-popout>

            </teleport>

        </template>

        <script type="module">

            export default {
                data() {
                    return {
                        templates: null,
                        group: null,
                        filter: '',
                        loading: true,
                        actionTemplate: null,
                    }
                },

                computed: {

                    filtered() {

                        let templates = [];

                        (this.templates || []).forEach(t => {

                            if (this.filter && !t.name.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return;
                            }

                            if (this.group && t.group != this.group ) return;
                            templates.push(t)
                        });

                        if (templates.length) {
                            // Sort templates by label or name
                            templates.sort((a, b) => {
                                return (a.name || '').localeCompare(b.name || '');
                            });
                        }

                        return templates;
                    },

                    groups() {
                        let groups = [];

                        (this.templates || []).forEach(c => {
                            if (!c.group || groups.indexOf(c.group) > -1) return;
                            groups.push(c.group);
                        });

                        return groups.sort();
                    }
                },

                mounted() {
                    this.load();
                },

                methods: {

                    load() {

                        this.loading = true;

                        this.$request('/layout-components/templates/load', {options:{}}).then(templates => {

                            this.templates = templates;
                            this.loading = false;
                        });
                    },

                    remove(template) {

                        App.ui.confirm('Are you sure?', () => {

                            this.$request('/layout-components/templates/remove', {template}).then(res => {
                                this.templates.splice(this.templates.indexOf(template), 1);
                                App.ui.notify('Template removed!');
                            });
                        });
                    },

                    toggleTemplateActions(component) {

                        if (!component) {
                            setTimeout(() => this.actionTemplate = null, 300);
                            return;
                        }

                        this.actionTemplate = component;
                    }
                }
            }

        </script>

    </vue-view>

</kiss-container>
