
<kiss-container class="kiss-margin" size="medium">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/system')?>"><?=t('Settings')?></a></li>
    </ul>

    <vue-view>

        <template>

            <div class="kiss-margin-large-bottom kiss-size-4 kiss-text-bold">
                <?=t('Custom Components')?>
            </div>

            <app-loader v-if="loading"></app-loader>

            <div v-if="components && components.length">

                <div class="kiss-margin">
                    <input type="text" class="kiss-input" :placeholder="t('Filter components...')" v-model="filter">
                </div>

                <div class="app-list-items animated fadeIn">

                    <kiss-card class="kiss-margin-small kiss-flex kiss-flex-middle animated fadeIn" gap="small" theme="shadowed contrast" hover="shadow bordered-primary" v-for="(component, idx) in filtered">
                        <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                            <canvas width="40" height="40"></canvas>
                            <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                                <div :style="{color: component.color || 'inherit' }"><kiss-svg :src="$baseUrl(component.icon || 'layout:assets/icons/component.svg')" width="30" height="30"></kiss-svg></div>
                            </div>
                            <a class="kiss-cover" :href="$routeUrl('/layout-components/component/'+component._id)"></a>
                        </div>
                        <div class="kiss-padding-small kiss-size-5 kiss-flex-1 kiss-position-relative">
                            <strong>{{component.meta.label || component.name}}</strong>
                            <a class="kiss-cover" :href="$routeUrl('/layout-components/component/'+component._id)"></a>
                        </div>
                        <div class="kiss-padding-small kiss-color-muted kiss-size-small">{{component.meta.group}}</div>
                        <a class="kiss-padding-small" @click="toggleComponentActions(component)"><icon>more_horiz</icon></a>
                    </kiss-card>

                </div>

            </div>

            <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted" v-if="components && (!components.length || !filtered.length)">
                <div>
                    <kiss-svg :src="$baseUrl('layout:assets/icons/component.svg')" width="60" height="60"></kiss-svg>
                    <p class="kiss-size-large kiss-margin-small-top"><?=t('No components')?></p>
                </div>
            </div>

            <teleport to="body">

                <app-actionbar>

                    <kiss-container size="medium">
                        <div class="kiss-flex kiss-flex-middle">
                            <div v-if="groups.length">
                                <span class="kiss-text-caption kiss-color-muted"><?=t('Group')?></span>
                                <div class="kiss-margin-xsmall-top kiss-display-block kiss-overlay-input">
                                    <div class="kiss-size-4" :class="{'kiss-color-muted': !group, 'kiss-text-bold': group}">{{ group || t('All groups') }}</div>
                                    <select v-model="group">
                                        <option :value="null">{{t('All')}}</option>
                                        <option :selected="group == name" v-for="name in groups">{{ name }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="kiss-flex-1"></div>
                            <a class="kiss-button kiss-button-primary" href="<?=$this->route('/layout-components/component')?>"><?=t('Add component')?></a>
                        </div>
                    </kiss-container>

                </app-actionbar>

                <kiss-popout :open="actionComponent && 'true'" @popoutclose="toggleComponentActions(null)">
                    <kiss-content>
                            <kiss-navlist v-if="actionComponent">
                                <ul>
                                    <li class="kiss-nav-header">{{ actionComponent.meta.label || actionComponent.name }}</li>
                                    <li>
                                        <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/layout-components/component/${actionComponent._id}`)">
                                            <icon class="kiss-margin-small-end">edit</icon>
                                            {{ t('Edit') }}
                                        </a>
                                    </li>
                                    <li>
                                        <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/layout-components/clone/${actionComponent._id}`)">
                                            <icon class="kiss-margin-small-end">control_point_duplicate</icon>
                                            {{ t('Clone') }}
                                        </a>
                                    </li>
                                    <li class="kiss-nav-divider"></li>
                                    <li>
                                        <a class="kiss-color-danger kiss-flex kiss-flex-middle" @click="remove(actionComponent)">
                                            <icon class="kiss-margin-small-end">delete</icon>
                                            {{ t('Delete') }}
                                        </a>
                                    </li>
                                </ul>
                            </kiss-navlist>
                    </kiss-content>
                </kiss-popout>

            </teleport>

        </template>

        <script type="module">

            export default {
                data() {
                    return {
                        components: null,
                        group: null,
                        filter: '',
                        loading: false,
                        actionComponent: null
                    }
                },

                computed: {

                    filtered() {

                        let components = [];

                        (this.components || []).forEach(c => {

                            if (this.filter && !`${c.name} ${c.meta.label || ''}`.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return;
                            }

                            if (this.group && c.meta.group != this.group ) return;
                            components.push(c)
                        });

                        if (components.length) {
                            // Sort components by label or name
                            components.sort((a, b) => {
                                return (a.meta?.label || a.name || '').localeCompare(b.meta?.label || b.name || '');
                            });
                        }

                        return components;
                    },

                    groups() {
                        let groups = [];

                        (this.components || []).forEach(c => {
                            if (!c.meta.group || groups.indexOf(c.meta.group) > -1) return;
                            groups.push(c.meta.group);
                        });

                        return groups.sort();
                    }
                },

                mounted() {
                    this.load()
                },

                methods: {

                    load() {

                        this.loading = true;

                        this.$request('/layout-components/load', {options:{}}).then(components => {

                            this.components = components;
                            this.loading = false;
                        });
                    },

                    remove(component) {

                        App.ui.confirm('Are you sure?', () => {

                            this.$request('/layout-components/remove', {component}).then(res => {
                                this.components.splice(this.components.indexOf(component), 1);
                                App.ui.notify('Component removed!');
                            });
                        });
                    },

                    toggleComponentActions(component) {

                        if (!component) {
                            setTimeout(() => this.actionComponent = null, 300);
                            return;
                        }

                        this.actionComponent = component;
                    }
                }
            }

        </script>

    </vue-view>

</kiss-container>
