<?php

$component['meta'] = new ArrayObject($component['meta'] ?? []);
$component['meta']['opts'] = new ArrayObject($component['meta']['opts'] ?? []);

?>
<kiss-container class="kiss-margin" size="small">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/system')?>"><?=t('Settings')?></a></li>
        <li><a href="<?=$this->route('/layout-components')?>"><?=t('Custom components')?></a></li>
    </ul>

    <vue-view>
        <template>

            <div class="kiss-margin-large-bottom kiss-size-3 kiss-text-bold">
                <span v-if="!component._id"><?=t('Create component')?></span>
                <span v-if="component._id"><?=t('Edit component')?></span>
            </div>

            <form :class="{'kiss-disabled':saving}" @submit.prevent="save">

                <div class="kiss-margin">
                    <label><?=t('Name')?></label>
                    <input class="kiss-input" type="text" pattern="[a-zA-Z0-9_]+" v-model="component.name" required>
                </div>

                <kiss-grid cols="2@m" class="kiss-margin">

                    <div>
                        <label><?=t('Display name')?></label>
                        <input class="kiss-input" type="text" v-model="component.meta.label">
                    </div>

                    <div>
                        <label><?=t('Group')?></label>
                        <input class="kiss-input" type="text" v-model="component.meta.group">
                    </div>

                </kiss-grid>

                <kiss-grid cols="2@m" class="kiss-margin">

                    <div>
                        <label><?=t('Component behavior')?></label>
                        <div class="kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-top">
                            <?=t('Standard uses optional children. Grid/Row use dedicated editors.')?>
                        </div>
                    </div>
                    <div>
                        <div class="kiss-overlay-input kiss-display-block kiss-align-right">
                            <span class="kiss-badge kiss-badge kiss-text-capitalize">{{ (component.meta.type || 'Standard') }}</span>
                            <select v-model="component.meta.type">
                                <option :value="null">Standard</option>
                                <option value="grid">Grid</option>
                                <option value="row">Row</option>
                            </select>
                        </div>
                    </div>

                </kiss-grid>

                <div class="kiss-flex" v-if="!['grid','row'].includes(component.meta.type)">
                    <div class="kiss-flex-1">
                        <label><?=t('Has child components?')?></label>
                        <div class="kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-top">
                            <?=t('Component can have nested layout components')?>
                        </div>
                    </div>
                    <field-boolean v-model="component.meta.children"></field-boolean>
                </div>

                <kiss-card class="kiss-margin kiss-padding" theme="contrast" v-if="component.meta.children">

                    <div class="kiss-flex kiss-flex-middle">
                        <label class="kiss-flex-1"><?=t('Allowed components')?></label>
                        <span class="kiss-badge">{{ Array.isArray(component.meta.allowedComponents) && component.meta.allowedComponents.length ? component.meta.allowedComponents.length : 'All '}}</span>
                    </div>
                    <div class="kiss-size-xsmall kiss-color-muted">
                        <?=t('List of child components to pick from')?>
                    </div>

                    <div class="kiss-margin" style="max-height: 200px; overflow: auto;">
                        <field-select
                            v-model="component.meta.allowedComponents"
                            label = 'Components'
                            info="List of components to pick from."
                            :multiple="true"
                            :src="{
                                route: '/layout/components?list=1&v='+Math.random(),
                                map: {value: 'name', label: 'label'}
                            }"
                        ></field-select>
                    </div>
                </kiss-card>

                <hr>

                <div class="kiss-flex">
                    <div class="kiss-flex-1">
                        <label><?=t('Icon')?></label>
                        <div class="kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-top">
                            <?=t('Component icon')?>
                        </div>
                    </div>
                    <div><icon-picker v-model="component.meta.icon" size="30" placeholder="layout:assets/icons/component.svg"></icon-picker></div>
                </div>

                <hr>

                <div class="kiss-margin">
                    <label><?=t('Data')?></label>
                    <fields-manager v-model="component.meta.fields"></fields-manager>
                </div>

                <div class="kiss-margin">
                    <label><?=t('Options')?></label>
                    <field-object v-model="component.meta.opts"></field-object>
                </div>

                <h4 class="kiss-margin-large-top">{{ t('Preview') }}</h4>

                <div class="kiss-margin">
                    <label><?=t('Image')?></label>
                    <bucket-file bucket="layout-components" type="image" v-model="component.meta.image"></bucket-file>
                </div>

                <div class="kiss-margin">
                    <label><?=t('Template')?></label>
                    <div class="kiss-margin-small kiss-color-muted kiss-flex kiss-flex-middle">
                        <icon class="kiss-size-4">info</icon>
                        <div class="kiss-size-small kiss-margin-xsmall-start">
                            <strong>Vue HTML Template</strong> -
                            Example <span class="kiss-text-monospace" v-pre>&lt;div v-if="data.fieldname"&gt;{{data.fieldname}}&lt;/div&gt;</span>
                        </div>
                    </div>
                    <field-code v-model="component.meta.preview" mode="html"></field-code>
                </div>

                <app-actionbar>

                    <kiss-container size="small">
                        <div class="kiss-flex kiss-flex-middle kiss-flex-end">
                            <div class="kiss-button-group">
                                <a class="kiss-button" href="<?=$this->route('/layout-components')?>">
                                    <span v-if="!component._id"><?=t('Cancel')?></span>
                                    <span v-if="component._id"><?=t('Close')?></span>
                                </a>
                                <button type="submit" class="kiss-button kiss-button-primary">
                                    <span v-if="!component._id"><?=t('Create component')?></span>
                                    <span v-if="component._id"><?=t('Update component')?></span>
                                </button>
                            </div>
                        </div>
                    </kiss-container>

                </app-actionbar>

            </form>

        </template>

        <script type="module">

            export default {

                data() {

                    return {
                        saving: false,
                        component: <?=json_encode($component)?>
                    };
                },

                components: {
                    BucketFile: Vue.defineAsyncComponent(() => App.utils.import('system:assets/vue-components/bucket-file.js')),
                },

                methods: {

                    save() {

                        let isUpdate = this.component._id;

                        this.saving = true;

                        if (!this.component.meta?.children && this.component.meta.allowedComponents) {
                            delete this.component.meta.allowedComponents;
                        }

                        this.$request('/layout-components/save', {component: this.component}).then(component => {

                            this.component = component;
                            this.saving = false;

                            if (isUpdate) {
                                App.ui.notify('Component updated!');
                            } else {
                                App.ui.notify('Component created!');
                            }
                        }).catch(res => {
                            this.saving = false;
                            App.ui.notify(res.error || 'Saving failed!', 'error');
                        })

                    }
                }
            }
        </script>

    </vue-view>

</kiss-container>
