let previewComponentCache = {};

export default {

    data() {

        let name = this.component.component;

        if (!previewComponentCache[name]) {

            let component;

            let def = {
                props:['data'],
                methods: {
                    truncate: App.utils.truncate,
                    stripTags: App.utils.stripTags,
                    sanitize: DOMPurify.sanitize
                }
            };

            if (this.globalComponents[name].preview && typeof(this.globalComponents[name].preview) == 'string') {
                def.template = this.globalComponents[name].preview;
                component = def;
            } else if (this.globalComponents[name].opts && this.globalComponents[name].opts.previewComponent) {
                component = Vue.defineAsyncComponent(() => App.utils.import(this.globalComponents[name].opts.previewComponent))
            }

            previewComponentCache[name] = component;
        }

        return {
            previewComponent: previewComponentCache[name]
        }
    },

    props: {
        component: {
            type: Object
        },
        globalComponents: {
            type: Object
        }
    },

    computed: {
        data() {
            return this.component.data;
        }
    },

    methods: {

    },

    template: /*html*/`
        <component :is="previewComponent" :data="data"></component>
    `
};
