<kiss-container class="kiss-margin-small">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/inbox')?>"><?=t('Inbox')?></a></li>
    </ul>

    <vue-view>

        <template>

            <div class="kiss-margin-large-bottom kiss-size-4 kiss-text-bold">
                <?=t('Forms')?>
            </div>

            <app-loader v-if="loading"></app-loader>

            <div v-if="forms && forms.length">

                <div class="kiss-margin">
                    <input type="text" class="kiss-input" :placeholder="t('Filter forms...')" v-model="filter">
                </div>

                <kiss-grid cols="2@l" gap="large">

                    <div>

                        <div class="kiss-margin kiss-text-caption kiss-text-bold kiss-color-muted kiss-size-small"><?= t('Forms') ?></div>

                        <kiss-card class="kiss-margin-small kiss-flex kiss-flex-middle animated fadeIn" theme="shadowed contrast" hover="shadow bordered-primary" gap="small" v-for="form in filtered">
                            <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                                <canvas width="40" height="40"></canvas>
                                <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                                    <div :style="{color: form.color || 'inherit' }"><kiss-svg :src="$baseUrl(form.icon || 'inbox:icon.svg')" width="30" height="30"></kiss-svg></div>
                                </div>
                                <a class="kiss-cover" :href="$routeUrl(`/inbox/submissions/form/${form._id}`)"></a>
                            </div>
                            <div class="kiss-padding-small">
                                <a class="kiss-text-bold kiss-link-muted" :href="$routeUrl(`/inbox/submissions/form/${form._id}`)">{{ form.name }}</a>
                            </div>
                            <div class="kiss-flex-1"></div>
                            <div class="kiss-align-right kiss-padding-small kiss-size-small kiss-color-muted kiss-visible@l">{{ form.info }}</div>
                            <div class="kiss-padding-small">
                                <a @click="toggleformActions(form)"><icon>more_horiz</icon></a>
                            </div>
                        </kiss-card>
                    </div>

                    <div>
                        <div class="kiss-margin kiss-text-caption kiss-text-bold kiss-color-muted kiss-size-small"><?= t('Submissions') ?></div>
                        <inbox-recent-submissions :forms="filtered" :open="3"></inbox-recent-submissions>
                    </div>

                </kiss-grid>

            </div>

            <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted" v-if="forms && (!forms.length || !filtered.length)">
                <div>
                    <kiss-svg :src="$baseUrl('inbox:icon.svg')" width="40" height="40"></kiss-svg>
                    <p class="kiss-size-large kiss-margin-small-top"><?=t('No forms')?></p>
                </div>
            </div>

            <app-actionbar>

                <kiss-container>
                    <div class="kiss-flex kiss-flex-middle">
                        <div v-if="groups.length">
                            <span class="kiss-text-caption kiss-color-muted"><?=t('group')?></span>
                            <div class="kiss-margin-xsmall-top kiss-display-block kiss-overlay-input">
                                <div class="kiss-size-4" :class="{'kiss-color-muted': !group, 'kiss-text-bold': group}">{{ group || t('All groups') }}</div>
                                <select v-model="group">
                                    <option :value="null">{{t('All')}}</option>
                                    <option :selected="group == name" v-for="name in groups">{{ name }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="kiss-flex-1"></div>
                        <?php if ($this->helper('acl')->isAllowed("inbox/manage")): ?>
                        <a class="kiss-button kiss-button-primary" href="<?=$this->route('/inbox/forms/form')?>"><?=t('Create form')?></a>
                        <?php endif ?>
                    </div>
                </kiss-container>

            </app-actionbar>

            <kiss-popout :open="actionform && 'true'" @popoutclose="toggleformActions(null)">
                <kiss-content>
                        <kiss-navlist v-if="actionform">
                            <ul>
                                <li class="kiss-nav-header">{{ actionform.label || actionform.name }}</li>
                                <li>
                                    <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/inbox/forms/form/${actionform._id}`)">
                                        <icon class="kiss-margin-small-end">create</icon>
                                        <?=t('Edit')?>
                                    </a>
                                </li>
                                <li class="kiss-nav-divider"></li>
                                <li>
                                    <a class="kiss-color-danger kiss-flex kiss-flex-middle" @click="remove(actionform)">
                                        <icon class="kiss-margin-small-end">delete</icon>
                                        <?=t('Delete')?>
                                    </a>
                                </li>
                            </ul>
                        </kiss-navlist>
                </kiss-content>
            </kiss-popout>

        </template>

        <script type="module">

            export default {

                components: {
                    'inbox-recent-submissions': Vue.defineAsyncComponent(() =>
                        App.utils.import('inbox:assets/vue-components/inbox-recent-submissions.js')
                    )
                },

                data() {
                    return {
                        forms: null,
                        group: null,
                        filter: '',
                        loading: false,
                        actionform: null
                    }
                },

                mounted() {
                    this.load()
                },

                computed: {

                    filtered() {

                        let forms = [];

                        (this.forms || []).forEach(p => {

                            if (this.filter && !`${p.name} ${p.label || ''}`.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return;
                            }

                            if (this.group && p.group != this.group ) return;
                            forms.push(p)
                        });

                        return forms;
                    },

                    groups() {
                        let groups = [];

                        (this.forms || []).forEach(p => {
                            if (!p.group || groups.indexOf(p.group) > -1) return;
                            groups.push(p.group);
                        });

                        return groups.sort();
                    }
                },

                methods: {

                    load() {

                        this.loading = true;

                        this.$request('/inbox/load', {options:{}}).then(forms => {

                            this.forms = forms;
                            this.loading = false;
                        });
                    },

                    remove(form) {

                        App.ui.confirm('Are you sure?', () => {

                            this.$request('/inbox/forms/remove', {form}).then(res => {
                                this.forms.splice(this.forms.indexOf(form), 1);
                                App.ui.notify('Form removed!');
                            });
                        });
                    },

                    toggleformActions(form) {

                        if (!form) {
                            setTimeout(() => this.actionform = null, 300);
                            return;
                        }

                        this.actionform = form;
                    }
                }
            }

        </script>

    </vue-view>


</kiss-container>
