<kiss-container class="kiss-margin-small" size="small">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/inbox')?>"><?=t('Inbox')?></a></li>
    </ul>

    <vue-view>
        <template>

            <h1 class="kiss-margin-large-bottom">
                <span v-if="!form._id"><?=t('Create form')?></span>
                <span v-if="form._id"><?=t('Edit form')?></span>
            </h1>

            <kiss-card class="kiss-padding kiss-margin-large" theme="contrast bordered" v-if="form.token">
                <div class="kiss-text-caption kiss-text-bold kiss-color-muted"><?=t('Form Token')?></div>
                <kiss-row class="kiss-margin-small">
                    <div class="kiss-text-monospace kiss-text-truncate kiss-flex-1 kiss-visible-toggle" gap="small">
                        <a class="kiss-link-muted kiss-flex-inline kiss-flex-middle" gap="small" @click="editToken()">
                            <span>{{ form.token }}</span>
                            <icon class="kiss-color-primary kiss-invisible-hover">edit</icon>
                        </a>
                    </div>
                    <div class="kiss-flex kiss-flex-middle" gap="small">
                        <a @click="generateToken"><icon class="kiss-size-large">refresh</icon></a>
                        <a @click="copyToken"><icon class="kiss-size-large">content_copy</icon></a>
                    </div>
                </kiss-row>
            </kiss-card>

            <form :class="{'kiss-disabled':saving}" @submit.prevent="save">

                <div class="kiss-text-caption kiss-text-bold">{{ t('General') }}</div>

                <kiss-grid cols="2@m" class="kiss-margin">
                    <div>
                        <label><?=t('Name')?></label>
                        <input class="kiss-input" type="text" v-model="form.name" required>
                    </div>
                    <div>
                        <label><?=t('Group')?></label>
                        <input class="kiss-input" type="text" list="form-groups" v-model="form.group">
                    </div>
                </kiss-grid>

                <div class="kiss-margin">
                    <label><?=t('Info')?></label>
                    <textarea class="kiss-input kiss-textarea" style="height:100px;" v-model="form.info"></textarea>
                </div>

                <div class="kiss-flex kiss-margin">
                    <div class="kiss-flex-1">
                        <label><?=t('Color')?></label>
                        <div class="kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-top">
                            <?=t('Accent color')?>
                        </div>
                    </div>
                    <field-color v-model="form.color" size="30"></field-color>
                </div>

                <hr>

                <div class="kiss-flex kiss-margin">
                    <div class="kiss-flex-1">
                        <label><?=t('Icon')?></label>
                        <div class="kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-top">
                            <?=t('Form icon')?>
                        </div>
                    </div>
                    <div><icon-picker v-model="form.icon" size="30"></icon-picker></div>
                </div>

                <kiss-tabs class="kiss-margin-large-top">

                    <tab :caption="t('Configuration')">

                        <div class="kiss-text-caption kiss-text-bold">{{ t('Notification') }}</div>

                        <div class="kiss-margin">
                            <label><?=t('Emails')?></label>
                            <field-tags v-model="form.notify.emails"></field-tags>
                            <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small">
                                <?=t('Get notification about new submissions')?>
                            </div>
                        </div>

                        <div class="kiss-text-caption kiss-text-bold kiss-margin-large-top">{{ t('Security') }}</div>

                        <div class="kiss-margin">
                            <label><?=t('Allowed domains')?></label>
                            <field-tags v-model="form.security.domains" :placeholder="t('Leave empty to allow any domain')"></field-tags>
                            <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small">
                                <?=t('Only submissions from these domains (and all subdomains) will be accepted')?>
                            </div>
                        </div>

                        <div class="kiss-margin">
                            <label><?=t('Allowed fields')?></label>
                            <field-tags v-model="form.security.fields" :placeholder="t('Leave empty to allow any input data')"></field-tags>
                            <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small">
                                <?=t('Only these fields are allowed from a submission')?>
                            </div>
                        </div>

                        <div class="kiss-margin">
                            <label><?=t('Allowed languages')?></label>
                            <field-tags v-model="form.security.languages" :placeholder="t('Leave empty to allow any language')" :list="locales"></field-tags>
                            <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small">
                                <?=t('Which languages should be accepted')?>
                            </div>
                        </div>

                        <div>
                            <label><?=t('Honeypot')?></label>
                            <input class="kiss-input" type="text" v-model="form.security.honeypot">
                            <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small">
                                <?=t('Hidden field name for spam bots')?>
                            </div>
                        </div>

                    </tab>

                    <tab :caption="t('Meta')">
                        <field-object v-model="form._meta"></field-object>
                    </tab>

                </kiss-tabs>

                <app-actionbar>

                    <kiss-container>
                        <div class="kiss-flex kiss-flex-middle">
                            <a class="kiss-button" :href="$routeUrl(`/inbox/submissions/form/${form._id}`)" v-if="form._id"><?=t('Goto submissions')?></a>
                            <div class="kiss-flex-1"></div>
                            <div class="kiss-button-group">
                                <a class="kiss-button" href="<?=$this->route('/inbox')?>">
                                    <span v-if="!form._id"><?=t('Cancel')?></span>
                                    <span v-if="form._id"><?=t('Close')?></span>
                                </a>
                                <button type="submit" class="kiss-button kiss-button-primary">
                                    <span v-if="!form._id"><?=t('Create form')?></span>
                                    <span v-if="form._id"><?=t('Update form')?></span>
                                </button>
                            </div>
                        </div>
                    </kiss-container>

                </app-actionbar>

                </form>

                <datalist id="form-groups" v-if="groups.length">
                    <option v-for="group in groups">{{ group }}</option>
                </datalist>


        </template>
        <script type="module">
            export default {

                data() {

                    let form = <?=json_encode($form)?>;

                    if (!form._meta || Array.isArray(form._meta)) {
                        form._meta = {};
                    }

                    return {
                        form,
                        groups: <?=json_encode($groups)?>,
                        locales: <?=json_encode($locales)?>,
                        saving: false
                    }
                },

                methods: {
                    save() {

                        let isUpdate = this.form._id;

                        this.saving = true;

                        this.$request('/inbox/forms/save', {form: this.form}).then(form => {

                            this.form = form;
                            this.saving = false;

                            if (isUpdate) {
                                App.ui.notify('Form updated!');
                            } else {
                                App.ui.notify('Form created!');
                                this.isUpdate = true;
                            }
                        }).catch(res => {
                            this.saving = false;
                            App.ui.notify(res.error || 'Saving failed!', 'error');
                        });
                    },

                    remove(locale) {
                        this.form.locales.splice(this.form.locales.indexOf(locale), 1);
                    },

                    generateToken() {

                        this.$request('/utils/generateToken').then(res => {
                            this.form.token = res.token;
                        });
                    },
                    copyToken() {

                        App.utils.copyText(this.form.token, () => {
                            App.ui.notify('Form token copied!');
                        });
                    },
                    editToken() {

                        App.ui.prompt('Edit form token', this.form.token, token => {

                            if (token.trim()) {
                                this.form.token = token.trim();
                            }
                        });
                    }
                }

            }
        </script>
    </vue-view>

</kiss-container>
