<div class="kiss-margin-small">
    <kiss-container>

        <?=$contents?>

    </kiss-container>
</div>

<?php $this->start('app-side-panel') ?>

<kiss-card>

    <h2 class="kiss-size-4"><?=t('Inbox')?></h2>

    <kiss-navlist>
        <ul>
            <li>
                <a class="kiss-flex kiss-flex-middle <?=($this->request->route === '/inbox' ? 'kiss-link-muted kiss-text-bold':'kiss-color-muted')?>" href="<?=$this->route('/inbox')?>">
                    <kiss-svg class="kiss-margin-small-end" src="<?=$this->base('inbox:icon.svg')?>" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg>
                    <?=t('Overview')?>
                </a>
            </li>
        </ul>
    </kiss-navlist>

    <vue-view class="kiss-margin">
        <template>

            <kiss-navlist>
                <ul>
                    <li class="kiss-nav-header kiss-margin-top kiss-margin-xsmall-bottom"><?=t('Forms')?></li>
                    <li v-for="form in processed">
                        <a class="kiss-flex kiss-flex-middle" gap="small" :class="form.isActive ? 'kiss-link-muted kiss-text-bold':'kiss-color-muted'" :href="$routeUrl(`/inbox/submissions/form/${form._id}`)">
                            <div :style="{color: form.isActive && form.color || 'inherit' }"><kiss-svg :src="$baseUrl(form.icon || 'inbox:icon.svg')" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg></div>
                            <div class="kiss-flex-1 kiss-text-truncate">{{ form.name }}</div>
                        </a>
                    </li>
                </ul>
            </kiss-navlist>

            <app-loader class="kiss-display-inline-block" size="small" mode="dots" v-if="loading"></app-loader>

            <kiss-card class="kiss-color-muted kiss-size-small kiss-margin-small" v-if="!loading && forms && !forms.length">
                <?=t('No form created yet')?>
            </kiss-card>

            <a class="kiss-button kiss-button-small kiss-margin" href="<?=$this->route('/inbox/forms/form')?>" v-if="!loading"><?=t('Create form')?></a>

        </template>

        <script type="module">

            export default {

                data() {
                    return {
                        forms: [],
                        loading: true
                    }
                },

                created() {

                    this.load();

                    AppEventStream.on('inbox.forms.updated', () => {
                        this.load();
                    });
                },

                computed: {
                    processed() {

                        this.forms.forEach(form => {
                            form.isActive = '<?=$this->request->route?>'.match(`/inbox/submissions/form/${form._id}`)
                        });

                        return this.forms;
                    }
                },

                methods: {

                    load() {

                        this.loading = true;

                        this.$request('/inbox/load', {options:{}}).then(forms => {

                            this.loading = false;
                            this.forms = forms;
                        });
                    }

                }

            }
        </script>

    </vue-view>

</kiss-card>

<?php $this->end('app-side-panel') ?>
