<!doctype html>
<html>
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Inbox Submission: <?=$form['name']?></title>
    </head>
    <body style="font-family:sans-serif;font-size:14px;padding:40px 20px;">

        <div>
            <small style="font-size:11px;">Inbox</small><br>
            <h1 style="font-size:24px;margin-top:10px;"><b><?=$form['name']?></b></h1>
        </div>

        <hr>
        <br>

        <?php foreach ($data as $field => $value): ?>
        <div>
            <small><b><?=ucfirst($field)?></b></small><br>
            <?php if (is_string($value)): ?>
                <?=nl2br(strip_tags($value))?>
            <?php else: ?>
                <pre><?=json_encode($value, JSON_PRETTY_PRINT)?></pre>
            <?php endif ?>
        </div>
        <br>
        <?php endforeach; ?>

        <?php if (count(array_keys($attachments))): ?>
        <br>
        <?php foreach ($attachments as $field => $files): ?>
        <div style="border:1px #eee solid;padding:10px;">
            <small><b><?=ucfirst($field)?></b></small><br>
            <?php if (count($files) == 1): $file = $files[0]; ?>
                <a href="<?=$this->fileStorage->getURL("uploads://{$file['file']}")?>"><?=$file['name']?></a>
            <?php else: ?>
                <?php foreach ($files as $file): ?>
                &mdash; <a href="<?=$this->fileStorage->getURL("uploads://{$file['file']}")?>"><?=$file['name']?></a><br>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <br>
        <?php endforeach; ?>

        <?php endif ?>

    </body>
</html>
