let jsonDataRenderer = {

    name: 'jsonDataRenderer',

    data() {
        return {
            closed: {}
        }
    },

    props: {
        json: {
            type: Object,
            default: {}
        },
        level: {
            type: Number,
            default: 0
        }
    },

    computed: {

        fields() {
            return Object.keys(this.json).sort();
        },
    },

    methods: {
        isObjectOrArray(val) { return Array.isArray(val) || (typeof val === 'object' && val !== null) },
        isNumeric(n) { return App.utils.isNumeric(n); }
    },

    template: /*html*/`
    <div>
        <kiss-card class="kiss-padding-small" :class="level === 0 ? 'kiss-margin-small':'kiss-bgcolor-contrast'" v-for="field in fields" :theme="level === 0 ? 'contrast bordered' : ''">
            <div class="kiss-text-caption kiss-text-bold kiss-flex kiss-flex-middle">
                <a class="kiss-margin-xsmall-end" v-if="isObjectOrArray(json[field])" @click="closed[field] = !closed[field]"><icon size="larger">unfold_more</icon></a>
                {{ isNumeric(field) ? '['+field+']' : field }}
            </div>
            <div class="kiss-margin-small" v-if="isObjectOrArray(json[field])">
                <json-data-renderer :json="json[field]" :level="level + 1" v-show="!closed[field]"></json-data-renderer>
                <a class="kiss-color-muted kiss-color-muted kiss-size-small" @click="closed[field] = !closed[field]" v-if="closed[field]">...</a>
            </div>
            <div class="kiss-margin-xsmall kiss-color-muted kiss-size-small" v-else>{{ json[field] || 'n/a' }}</div>
        </kiss-card>
    </div>
    `
};

export default {

    _meta: {flip: true, size: 'xlarge'},

    data() {

        return {

        }
    },

    props: {
        submission: {
            type: Object
        }
    },

    components: {
        dataRenderer: jsonDataRenderer
    },

    computed: {
        fields() {
            return Object.keys(this.submission.data);
        },

        attachments() {

            if (Array.isArray(this.submission.attachments) && !this.submission.attachments.length) {
                return null;
            }

            return this.submission.attachments || [];
        }
    },

    template: /*html*/`
        <div class="app-offcanvas-container">
            <div class="kiss-padding kiss-flex kiss-flex-middle">
                <div class="kiss-margin-small-end">
                    <kiss-svg :src="$baseUrl('inbox:assets/icons/submissions.svg')" width="35" height="35"><canvas width="35" height="35"></canvas></kiss-svg>
                </div>
                <div>
                    <strong>{{ t('Submission') }}</strong>
                    <div class="kiss-size-small kiss-text-monospace kiss-color-muted">
                        {{ (new Date(submission._created * 1000).toLocaleString())  }}
                    </div>
                </div>
            </div>
            <div class="app-offcanvas-content kiss-padding kiss-bgcolor-contrast">

                <data-renderer :json="submission.data" :level="0"></data-renderer>

                <div class="kiss-margin-top" v-if="attachments">

                    <div class="kiss-margin-small kiss-text-bold kiss-text-caption kiss-color-muted">{{ t('Attachments') }}</div>

                    <kiss-card v-for="files,field in attachments">

                        <div class="kiss-text-caption">{{field}}</div>

                        <div class="kiss-margin-xsmall" v-for="file in files">
                            <a class="kiss-flex kiss-flex-middle kiss-text-monospace" :href="$baseUrl('#uploads:'+file.file)" target="_blank" rel="noopener" download>
                                <icon class="kiss-margin-small-end">attachment</icon>
                                <span class="kiss-size-small">{{ file.name}}</span>
                            </a>
                        </div>
                    </kiss-card>

                </div>

            </div>
            <div class="kiss-padding">
                <button class="kiss-button kiss-width-1-1" kiss-offcanvas-close>{{ t('Close') }}</button>
            </div>
        </div>
    `
}
