<?php

namespace Inbox\Controller;

class Inbox extends Controller {

    protected function before() {

        if (!$this->isAllowed('inbox/submissions')) {
            return $this->stop(401);
        }
    }

    public function index() {

        $this->helper('theme')->favicon('inbox:icon.svg');

        return $this->render('inbox:views/index.php');
    }

    public function load() {

        $this->helper('session')->close();
        $this->hasValidCsrfToken(true);

        $options = [
            'sort' => ['name' => 1]
        ];

        $forms = $this->app->dataStorage->find('inbox/forms', $options)->toArray();

        return $forms;
    }

}
