export default {

    _meta: {flip: true, size: 'xlarge'},

    data() {

        let data = JSON.parse(JSON.stringify(this.document));

        delete data.id;

        return {
            data,
            loading: false
        }
    },

    props: {

        index: {
            type: Object
        },

        document: {
            type: Object
        }
    },

    computed: {

    },

    methods: {

        update() {

            this.loading = true;

            this.$request(`/detektivo/idx/replace/${this.index.name}/${this.document.id}`, {data: this.data}).then((res) => {

                this.loading = false;

                Object.assign(this.document, res.data);

                Object.keys(this.document).forEach(k => {
                    if (res.data[k] === undefined) delete this.document[k];
                })

                App.ui.notify('Document updated!');

            }).catch(res => {

                this.loading = false;
                App.ui.notify(res.error || 'Updating failed!', 'error');
            });
        }
    },

    template: /*html*/`
        <div class="app-offcanvas-container">
            <div class="kiss-padding kiss-text-bold kiss-flex kiss-flex-middle">
                <div class="kiss-margin-small-end"><icon size="larger">edit</icon></div>
                <div class="kiss-flex-1 kiss-margin-small-end">{{ t('Document') }}</div>
                <span class="kiss-badge">{{document.id}}</span>
            </div>
            <div class="app-offcanvas-content" :class="{'kiss-disabled': loading}">
                <field-object embed="true" height="auto" v-model="data"></field-object>
            </div>
            <div class="kiss-padding kiss-button-group kiss-flex kiss-flex-end" :class="{'kiss-disabled': loading}">
                <button class="kiss-button kiss-button-primary" @click="update()">{{ t('Update') }}</button>
                <button class="kiss-button" kiss-offcanvas-close>{{ t('Close') }}</button>
            </div>
        </div>
    `
}
