<?php


return [
    'name' => 'pages',
    'label' => 'Pages',
    'info' => 'Index pages',
    'icon' => 'pages:icon.svg',
    'meta' => [
        [
            'name' => 'populate',
            'type' => 'number',
            'label' => 'Populate',
            'info' => 'Populate level of linked content before indexing',
            'required' => true,
            'opts' => ['default' => '0']
        ]
    ],

    'fields' => function($meta = null) {
        return include(__DIR__.'/fields.php');
    },

    'index' => function($index, $idx) {

        $idx->clear();

        $populate = $index['meta']['populate'] ?? 0;
        $settings = $this->module('pages')->settings();

        $pages = $this->app->dataStorage->find('pages', [
            'filter' => ['_state' => 1]
        ])->toArray();

        if (!count($pages)) {
            return;
        }

        $locales = array_keys($this->app->helper('locales')->locales(true));
        $indexed = 0;

        foreach ($pages as $page) {

            $documents = [];

            foreach ($locales as $locale) {

                $_page = $this->app->helper('pages')->processPage($page, ['locale' => $locale, 'limit' => 1000]);
                $_page['id'] = $_page['_id'].($locale == 'default' ? '' : "_{$locale}");
                $_page['locale'] = $locale;

                if ($locale !== 'default' && (
                    (isset($settings['locales'][$locale]) && $settings['locales'][$locale] === false) || // is locale disabled globally?
                    (isset($page['_locales'][$locale]) && $page['_locales'][$locale] === false) // is locale disabled for this page?
                )) {
                    continue;
                }

                unset($_page['_id']);

                $documents[] = $_page;

                if (isset($_page['data']['items']) && is_array($_page['data']['items'])) {

                    foreach ($_page['data']['items'] as $item) {

                        if (isset($item['route'])) {
                            $p = $this->app->module('pages')->pageByRoute($item['route'], ['locale' => $locale]);

                            if ($p) {
                                $p['_r'] = $item['route'];
                                $p['id'] = $p['_id'].($locale == 'default' ? '' : $locale);
                                $p['locale'] = $locale;

                                unset($p['_id']);
                                $documents[] = $p;
                            }
                        }
                    }
                }
            }

            // Check if indexer was not stopped
            if ($indexed > 50) {
                if (!$this->isIndexerRunning()) return;
                $indexed = 0;
            }

            $idx->addDocuments($documents);
            $indexed += count($documents);
        }


    }
];
