<?php

namespace Detektivo\Controller;


class Idx extends Controller {

    public function __catchall() {

        $args = func_get_args();

        if (count($args) == 1) {
            return $this->index($args[0]);
        }

        if (count($args) == 2 && $args[1] == 'run') {
            return $this->run($args[0]);
        }
    }

    public function index($name = null) {

        if (!$name || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        $index = $this->module('detektivo')->indexes($name);
        $type = $this->module('detektivo')->indexTypes($index['type']);
        $idx =$this->module('detektivo')->index($name, true);

        $this->helper('theme')->favicon('detektivo:assets/icons/index.svg', $index['color'] ?? '#000');

        return $this->render('detektivo:views/idx/index.php', compact('index', 'idx', 'type'));

    }

    public function remove($name = null, $id = null) {

        $this->hasValidCsrfToken(true);

        if (!$name || !$id || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        $this->module('detektivo')->index($name)->removeDocument($id);

        return ['success' => true];
    }

    public function replace($name = null, $id = null) {

        $this->hasValidCsrfToken(true);

        if (!$name || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        $data = $this->param('data', null);

        if (!$id || !$data) {
            return $this->stop(412);
        }

        $data['id'] = $id;

        $this->module('detektivo')->index($name)->replaceDocument($id, $data);

        return ['success' => true, 'data' => $data];
    }

    public function clear($name = null) {

        $this->hasValidCsrfToken(true);

        if (!$name || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        $this->module('detektivo')->index($name)->clear();

        $this->helper('eventStream')->add('detektivo.indexes.updated', ['action' => 'remove', 'name' => $name]);

        return ['success' => true];
    }

    public function import($name = null) {

        $this->helper('session')->close();
        $this->hasValidCsrfToken(true);

        if (!$name || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        $items = $this->param('items', []);
        $idx = $this->module('detektivo')->index($name);

        if (count($items)) {
            $idx->addDocuments($items);
        }

        return ['success' => true];

    }

    public function run($name = null, $execute = 0) {

        $this->helper('session')->close();

        if (!$name || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        if ($execute) {
            $this->hasValidCsrfToken(true);
            //$this->module('detektivo')->runIndexer($name);
            return $this->helper('async')->exec('Cockpit()->module("detektivo")->runIndexer($name);', compact('name'));
            return ['success' => true, 'message' => 'Indexer started'];
        }

        $isRunning = $this->module('detektivo')->isIndexerRunning($name);
        $index = $this->module('detektivo')->indexes($name);
        $type = $this->module('detektivo')->indexTypes($index['type']);
        $idx =$this->module('detektivo')->index($name, true);

        return $this->render('detektivo:views/idx/run.php', compact('index', 'idx', 'type', 'isRunning'));
    }

    public function getRunnerLog($name) {

        $this->helper('session')->close();

        if (!$name || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        $log = $this->module('detektivo')->getIndexerLog($name);

        return ['success' => true, 'log' => $log];
    }

    public function stopRunner($name = null) {

        if (!$name || !$this->module('detektivo')->exists($name)) {
            return false;
        }

        $this->app->dataStorage->removeKey('detektivo/indexer', $name);

        return ['success' => true];

    }
}
