<?php

use GuzzleHttp\Client;

include_once(__DIR__.'/vendor/autoload.php');

// Register Agent helper
$this->helpers['autopilot:agent'] = 'Autopilot\\Helper\\Agent';

// load admin related code
$this->on('app.admin.init', function () {
    include(__DIR__ . '/admin.php');
});

// Autopilot api
$this->module('autopilot')->extend([

    '_apiKey' => null,
    '_client' => null,

    'apiKey' => function() {

        if (!isset($this->_apiKey)) {
            $this->_apiKey = $this->app->retrieve('autopilot/openAI/apiKey');
        }

        return $this->_apiKey;
    },

    'chatModel' => function() {
        return $this->app->retrieve('autopilot/openAI/chatModel', 'gpt-5-nano');
    },

    'client' => function() {

        if (!isset($this->_client)) {

            $this->_client = OpenAI::factory()
                                ->withApiKey($this->apiKey())
                                ->withBaseUri($this->app->retrieve('autopilot/openAI/baseUri', 'api.openai.com/v1'))
                                ->withHttpClient(new Client([]))
                                ->make();
        }

        return $this->_client;
    }

]);
