const actions = {

    prompt: {
        label: 'Prompt',
        icon: 'chat',
        handler(root) {

            VueView.ui.modal('autopilot:assets/dialogs/image.js', {
                fields: Object.keys(root.document).filter(field => field[0] !== '_')
            }, {
                onChooseImage(url) {

                    if (!url) return;

                    App.ui.block(App.i18n.get('Importing image'));

                    App.request('/autopilot/imageToAsset', {url}).then((rsp) => {

                        if (!rsp || !rsp.asset) {
                            return;
                        }

                        root.updateValue(rsp.asset);

                    }).finally(() => {
                        App.ui.unblock();
                    });

                }
            });

        }
    },
}

export default {

    init() {
        return new Promise((resolve, reject) => {
            resolve(actions);
        });
    },
}
