
let fieldTypeActions = {
    asset: 'autopilot:assets/vue-components/field-actions/asset.js',
    text: 'autopilot:assets/vue-components/field-actions/text.js',
    wysiwyg: 'autopilot:assets/vue-components/field-actions/wysiwyg.js',
}

App.trigger('autopilot-fieldtype-actions', { fieldTypeActions });

export default {

    data() {
        return {
            val: this.modelValue,
            showActionsPopout: false,
            ready: false,
            actions: [],
        }
    },

    props: {
        modelValue: {
            default: null
        },
        field: {
            type: Array,
            default: []
        },
        document: {
            type: Object,
            default: null
        },
        locale: {
            type: String,
            default: null
        },
    },

    beforeMount() {

        if (!fieldTypeActions[this.field.type]) {
            return;
        }

        App.utils.import(fieldTypeActions[this.field.type]).then((module) => {

            module.default.init().then(actions => {
                this.actions = actions;
                this.ready = true;
            });

        }, err => {

        });
    },

    watch: {
        modelValue() {
            this.val = this.modelValue;
        }
    },

    methods: {

        updateValue(value) {
            this.val = value;
            this.update();
        },

        update() {
            this.$emit('update:modelValue', this.val)
        },

        showActions() {

            if (Object.keys(this.actions).length === 1) {
                return this.callAction(Object.keys(this.actions)[0]);
            }

            this.showActionsPopout = true;
        },

        hideActions() {
            setTimeout(() => this.showActionsPopout = false, 200);
        },

        execute(messages, ready, opts) {

            opts = Object.assign({
                resource: 'chat',
                messages: messages
            }, opts || {})

            this.showActionsPopout = false;

            App.ui.block();

            this.$request('/autopilot/chat', opts, 'text').then(message => {

                ready(message);

            }).catch(error => {
                console.error(error);
                App.ui.notify('Oops! Something went wrong.', 'error');
            }).finally(() => {
                App.ui.unblock();
            });
        },

        callAction(name) {

            if (!this.actions[name]) {
                return;
            }

            this.actions[name].handler(this);
        }
    },

    template: /*html*/`
        <div v-if="!field.multiple && ready">
            <button type="button" class="kiss-input-blank kiss-cursor-pointer kiss-flex kiss-flex-middle" :aria-label="t('AI Assistant')" kiss-tooltip="bottom-right" @click="showActions()">
                <kiss-svg :src="$baseUrl('autopilot:assets/icons/magic.svg')" width="1em"><canvas width="1em" height="1em"></canvas></kiss-svg>
            </button>
        </div>
        <teleport to="body" v-if="showActionsPopout">
            <kiss-popout open="true" @popoutclose="hideActions">
                <kiss-content>
                    <kiss-navlist>
                        <ul>
                            <li class="kiss-nav-header kiss-flex kiss-flex-middle" gap="small">
                                <kiss-svg :src="$baseUrl('autopilot:assets/icons/magic.svg')" width="1.2em"><canvas width="1.2em" height="1.2em"></canvas></kiss-svg>
                                {{ t('AI actions') }}
                            </li>
                            <li v-for="(meta, action) in actions">
                                <a class="kiss-flex kiss-flex-middle" @click="callAction(action)">
                                    <icon class="kiss-margin-small-end">{{ meta.icon || 'smart_toy'}}</icon>
                                    <span class="kiss-text-capitalize">{{ t(meta.label || action) }}</span>
                                </a>
                            </li>
                        </ul>
                    </kiss-navlist>
                </kiss-content>
            </kiss-popout>
        </teleport>
    `
}
