<?php

/**
 * Cockpit Help Tool
 * Get help and examples of questions you can ask about Cockpit CMS
 */

return [
    'name' => 'getCockpitHelp',
    'description' => 'Get information how to use the chat to work with Cockpit CMS',
    'parameters' => [
        'type' => 'object',
        'properties' => new \stdClass(),
        'required' => [],
        'additionalProperties' => false
    ],
    'handler' => function($args, $app) {

        return [
            'description' => 'I can help you interact with your Cockpit CMS instance. Here are some things you can ask me:',
            'tools' => array_filter(array_map(fn($tool) => $tool['function']['name'] === 'getCockpitHelp' ? '' : $tool['function']['description'], $app->helper('autopilot:agent')->tools()))
        ];
    },
    'options' => ['permission' => 'autopilot/tools/read']
];
