<kiss-container class="kiss-margin-small">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?= $this->route('/content') ?>"><?= t('Content') ?></a></li>
    </ul>

    <vue-view>
        <template>

            <div class="kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center" v-if="loading">
                <app-loader></app-loader>
            </div>

            <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted kiss-margin-large" v-if="!loading && !models.length">
                <div>
                    <kiss-svg src="<?= $this->base('content:icon.svg') ?>" width="40" height="40"></kiss-svg>
                    <p class="kiss-size-large kiss-margin-top"><?= t('No models') ?></p>
                </div>
            </div>

            <div v-if="!loading && models.length">

                <div class="kiss-margin">
                    <input type="text" class="kiss-input" :placeholder="t('Filter models...')" v-model="filter">
                </div>

                <div class="kiss-button-group kiss-margin-large-bottom">
                    <button class="kiss-button kiss-button-small" :class="{'kiss-button-primary': !filterModelType}" @click="filterModelType=null"><?= t('All') ?></button>
                    <button class="kiss-button kiss-button-small" :class="{'kiss-button-primary': filterModelType=='singletons'}" @click="filterModelType='singletons'"><?= t('Singletons') ?></button>
                    <button class="kiss-button kiss-button-small" :class="{'kiss-button-primary': filterModelType=='collections'}" @click="filterModelType='collections'"><?= t('Collections') ?></button>
                    <button class="kiss-button kiss-button-small" :class="{'kiss-button-primary': filterModelType=='trees'}" @click="filterModelType='trees'"><?= t('Trees') ?></button>
                </div>

                <app-scrollcontainer mode="boundary-include" boundary="app-actionbar">

                    <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted kiss-margin-large" v-if="!singletons.length && !collections.length && !trees.length">
                        <div>
                            <kiss-svg src="<?= $this->base('content:icon.svg') ?>" width="40" height="40"></kiss-svg>
                            <p class="kiss-size-large kiss-margin-top"><?= t('No models found') ?></p>
                        </div>
                    </div>

                    <div class="kiss-text-caption kiss-text-bold kiss-margin" v-if="group">
                        &mdash; {{group}}
                    </div>

                    <kiss-grid cols="2@l" gap="large">

                        <div>

                            <div class="kiss-margin" v-if="singletons.length">

                                <div class="kiss-margin kiss-text-caption kiss-text-bold kiss-color-muted kiss-size-small"><?= t('Singletons') ?></div>


                                <kiss-grid cols="2@l" class="kiss-margin" gap="small">

                                    <kiss-card class="animated fadeIn kiss-flex" theme="shadowed contrast" hover="shadow bordered-primary" v-for="model in singletons">
                                        <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                                            <canvas width="40" height="40"></canvas>
                                            <div class="kiss-cover kiss-flex kiss-padding-small kiss-flex-middle kiss-flex-center">
                                                <div :style="{color: model.color || 'inherit' }"><kiss-svg :src="$baseUrl(model.icon || 'content:assets/icons/singleton.svg')" width="30" height="30"></kiss-svg></div>
                                            </div>
                                            <a class="kiss-cover" :href="$routeUrl(`/content/singleton/item/${model.name}`)"></a>
                                        </div>
                                        <div class="kiss-padding-small kiss-flex-1 kiss-position-relative">
                                            <div class="kiss-size-small kiss-text-bold kiss-text-truncate">{{ model.label || model.name }}</div>
                                            <div class="kiss-margin-xsmall-top kiss-color-muted kiss-size-xsmall kiss-text-truncate">{{model.info || t('Singleton')}}</div>
                                            <a class="kiss-cover" :href="$routeUrl(`/content/singleton/item/${model.name}`)" :aria-label="model.label || model.name"></a>
                                        </div>
                                        <a class="kiss-padding-small kiss-color-muted" @click="toggleModelActions(model)">
                                            <icon>more_vert</icon>
                                        </a>
                                    </kiss-card>

                                </kiss-grid>

                            </div>

                            <div class="kiss-margin" v-if="collections.length">

                                <div class="kiss-margin kiss-text-caption kiss-text-bold kiss-color-muted kiss-size-small"><?= t('Collections') ?></div>

                                <kiss-card class="kiss-margin-small kiss-flex animated fadeIn" theme="shadowed contrast" hover="shadow bordered-primary" v-for="model in collections">
                                    <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                                        <canvas width="40" height="40"></canvas>
                                        <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                                            <div :style="{color: model.color || 'inherit' }"><kiss-svg :src="$baseUrl(model.icon || 'content:assets/icons/'+model.type+'.svg')" width="30" height="30"></kiss-svg></div>
                                        </div>
                                        <a class="kiss-cover" :href="$routeUrl(`/content/${model.type}/items/${model.name}`)" :aria-label="model.label || model.name"></a>
                                    </div>
                                    <div class="kiss-padding-small kiss-flex-1 kiss-position-relative">
                                        <div class="kiss-size-small kiss-text-bold kiss-text-truncate">{{ model.label || model.name }}</div>
                                        <div class="kiss-margin-xsmall-top kiss-color-muted kiss-size-xsmall kiss-text-truncate">{{model.info || model.type}}</div>
                                        <a class="kiss-cover" :href="$routeUrl(`/content/${model.type}/items/${model.name}`)" :aria-label="model.label || model.name"></a>
                                    </div>
                                    <a class="kiss-padding-small kiss-color-muted" @click="toggleModelActions(model)">
                                        <icon>more_vert</icon>
                                    </a>
                                </kiss-card>
                                
                            </div>

                            <div class="kiss-margin" v-if="trees.length">
        
                                <div class="kiss-margin kiss-text-caption kiss-text-bold kiss-color-muted kiss-size-small"><?= t('Trees') ?></div>

                                <kiss-card class="kiss-margin-small kiss-flex animated fadeIn" theme="shadowed contrast" hover="shadow bordered-primary" v-for="model in trees">
                                    <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                                        <canvas width="40" height="40"></canvas>
                                        <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                                            <div :style="{color: model.color || 'inherit' }"><kiss-svg :src="$baseUrl(model.icon || 'content:assets/icons/'+model.type+'.svg')" width="30" height="30"></kiss-svg></div>
                                        </div>
                                        <a class="kiss-cover" :href="$routeUrl(`/content/${model.type}/items/${model.name}`)" :aria-label="model.label || model.name"></a>
                                    </div>
                                    <div class="kiss-padding-small kiss-flex-1 kiss-position-relative">
                                        <div class="kiss-size-small kiss-text-bold kiss-text-truncate">{{ model.label || model.name }}</div>
                                        <div class="kiss-margin-xsmall-top kiss-color-muted kiss-size-xsmall kiss-text-truncate">{{model.info || model.type}}</div>
                                        <a class="kiss-cover" :href="$routeUrl(`/content/${model.type}/items/${model.name}`)" :aria-label="model.label || model.name"></a>
                                    </div>
                                    <a class="kiss-padding-small kiss-color-muted" @click="toggleModelActions(model)">
                                        <icon>more_vert</icon>
                                    </a>
                                </kiss-card>

                            </div>
                        </div>


                        <div v-if="(collections.length + trees.length) > 0">
                            <content-recent-items :models="collections.concat(trees)" :open="3"></content-recent-items>
                        </div>


                    </kiss-grid>


                </app-scrollcontainer>

            </div>

            <app-actionbar space="false">

                <kiss-container>
                    <div class="kiss-flex kiss-flex-middle">
                        <div v-if="groups.length">
                            <span class="kiss-text-caption kiss-color-muted"><?= t('Group') ?></span>
                            <div class="kiss-margin-xsmall-top kiss-display-block kiss-overlay-input">
                                <div class="kiss-size-4" :class="{'kiss-color-muted': !group, 'kiss-text-bold': group}">{{ group || t('All groups') }}</div>
                                <select v-model="group">
                                    <option :value="null">{{t('All')}}</option>
                                    <hr />
                                    <option :selected="group == name" v-for="name in groups">{{ name }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="kiss-flex-1"></div>
                        <?php if ($this->helper('acl')->isAllowed("content/:models/manage")) : ?>
                            <a class="kiss-button kiss-button-primary" href="<?= $this->route('/content/models/create') ?>"><?= t('Create model') ?></a>
                        <?php endif ?>
                    </div>
                </kiss-container>

            </app-actionbar>

            <kiss-popout :open="actionModel && 'true'" @popoutclose="toggleModelActions(null)">
                <kiss-content>
                    <kiss-navlist v-if="actionModel">
                        <ul>
                            <li class="kiss-nav-header">{{ actionModel.label || actionModel.name }}</li>
                            <li>
                                <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/content/models/edit/${actionModel.name}`)">
                                    <icon class="kiss-margin-small-end">create</icon>
                                    <?= t('Edit') ?>
                                </a>
                            </li>
                            <li class="kiss-nav-divider"></li>
                            <li>
                                <a class="kiss-flex kiss-flex-middle" @click="clone(actionModel)">
                                    <icon class="kiss-margin-small-end">control_point_duplicate</icon>
                                    <?= t('Clone') ?>
                                </a>
                            </li>
                            <li v-if="actionModel.type=='collection'">
                                <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/content/collection/item/${actionModel.name}`)">
                                    <icon class="kiss-margin-small-end">add_circle</icon>
                                    <?= t('Create item') ?>
                                </a>
                            </li>
                            <li class="kiss-nav-divider"></li>
                            <li>
                                <a class="kiss-color-danger kiss-flex kiss-flex-middle" @click="remove(actionModel)">
                                    <icon class="kiss-margin-small-end">delete</icon>
                                    <?= t('Delete') ?>
                                </a>
                            </li>
                        </ul>
                    </kiss-navlist>
                </kiss-content>
            </kiss-popout>

            <teleport to="#content-models-aside" v-if="!loading">

                <kiss-card class="kiss-margin-small">
                    <span class="kiss-text-caption kiss-size-xsmall"><?= t('Models') ?></span>
                    <div class="kiss-size-3 kiss-text-bold kiss-margin-small-top">{{ (singletons.length + collections.length + trees.length) }}</div>
                </kiss-card>

                <kiss-grid cols="2" gap="small" v-if="!filterModelType">
                    
                    <kiss-card class="kiss-padding-small" theme="bordered">
                        <span class="kiss-text-caption kiss-size-xsmall kiss-color-muted"><?= t('Singletons') ?></span>
                        <div class="kiss-size-3 kiss-color-muted">{{ singletons.length }}</div>
                    </kiss-card>
                    <kiss-card class="kiss-padding-small" theme="bordered">
                        <span class="kiss-text-caption kiss-size-xsmall kiss-color-muted"><?= t('Collections') ?></span>
                        <div class="kiss-size-3 kiss-color-muted">{{ collections.length }}</div>
                    </kiss-card>
                    <kiss-card class="kiss-padding-small" theme="bordered">
                        <span class="kiss-text-caption kiss-size-xsmall kiss-color-muted"><?= t('Trees') ?></span>
                        <div class="kiss-size-3 kiss-color-muted">{{ trees.length }}</div>
                    </kiss-card>
                </kiss-grid>
            </teleport>

        </template>

        <script type="module">
            export default {
                data() {
                    return {
                        models: [],
                        loading: false,
                        actionModel: null,
                        group: null,
                        filter: '',
                        filterModelType: null,
                        
                    }
                },

                components: {
                    'content-recent-items': Vue.defineAsyncComponent(() =>
                        App.utils.import('content:assets/vue-components/content-recent-items.js')
                    )
                },

                computed: {

                    collections() {

                        if (this.filterModelType && this.filterModelType != 'collections') {
                            return [];
                        }

                        return this.models.filter(model => {

                            if (this.filter && !`${model.name} ${model.label}`.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return false;
                            }

                            return ['collection'].includes(model.type) && (!this.group || this.group == model.group);
                        });
                    },

                    trees() {

                        if (this.filterModelType && this.filterModelType != 'trees') {
                            return [];
                        }

                        return this.models.filter(model => {

                            if (this.filter && !`${model.name} ${model.label}`.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return false;
                            }

                            return ['tree'].includes(model.type) && (!this.group || this.group == model.group);
                        });
                    },

                    singletons() {

                        if (this.filterModelType && this.filterModelType != 'singletons') {
                            return [];
                        }

                        return this.models.filter(model => {

                            if (this.filter && !`${model.name} ${model.label}`.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return false;
                            }

                            return model.type == 'singleton' && (!this.group || this.group == model.group)
                        });
                    },

                    groups() {

                        let groups = [];

                        (this.models || []).forEach(model => {
                            if (!model.group || groups.indexOf(model.group) > -1) return;
                            groups.push(model.group);
                        });

                        return groups.sort();
                    }
                },

                mounted() {
                    this.load();
                },

                methods: {

                    load() {

                        this.loading = true;

                        App.utils.getContentModels().then(models => {
                            this.models = Object.values(models);
                            this.loading = false;
                        })
                    },

                    toggleModelActions(model) {

                        if (!model) {
                            setTimeout(() => this.actionModel = null, 300);
                            return;
                        }

                        this.actionModel = model;
                    },

                    remove(model) {

                        App.ui.confirm('Are you sure?', () => {

                            this.$request(`/content/models/remove/${model.name}`, {}).then(res => {
                                this.models.splice(this.models.indexOf(model), 1);
                                App.ui.notify('Model removed!');
                            }).catch(rsp => {
                                App.ui.notify(rsp.error || 'Removing model failed!', 'error');
                            });;
                        });
                    },

                    clone(model) {

                        App.ui.prompt(this.t('New model name'), '', name => {

                            this.$request(`/content/models/clone/${model.name}`, {
                                name
                            }).then(newmodel => {
                                this.models.push(newmodel);
                                App.ui.notify('Model duplicated!');
                            }).catch(rsp => {
                                App.ui.notify(rsp.error || 'Duplicating model failed!', 'error');
                            });
                        });
                    },

                }
            }
        </script>

    </vue-view>


</kiss-container>


<?php $this->start('app-side-panel') ?>

<h2 class="kiss-size-4"><?= t('Content') ?></h2>

<kiss-navlist>
    <ul>
        <li>
            <a class="kiss-link-muted kiss-flex kiss-flex-middle kiss-text-bold" href="<?= $this->route('/content') ?>">
                <kiss-svg class="kiss-margin-small-end" src="<?= $this->base('content:icon.svg') ?>" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg>
                <?= t('Overview') ?>
            </a>
        </li>
    </ul>
</kiss-navlist>

<div class="kiss-margin" id="content-models-aside"></div>

<?php if ($this->helper('acl')->isAllowed("content/:models/manage")) : ?>

    <span class="kiss-text-caption kiss-size-xsmall"><?=t('Create Model')?></span>

    <kiss-grid cols="3" class="kiss-margin kiss-color-muted kiss-align-center" gap="small">
        <kiss-card class="kiss-padding kiss-position-relative kiss-color-primary@hover" kiss-tooltip aria-label="<?= t('Collection') ?>" theme="bordered" hover="bordered-primary">
            <kiss-svg src="<?= $this->base('content:assets/icons/collection.svg') ?>" width="25" height="25"><canvas width="25" height="25"></canvas></kiss-svg>
            <a class="kiss-cover" href="<?= $this->route('/content/models/create') ?>?type=collection"></a>
        </kiss-card>
        <kiss-card class="kiss-padding kiss-position-relative kiss-color-primary@hover" kiss-tooltip aria-label="<?= t('Tree') ?>" theme="bordered" hover="bordered-primary">
            <kiss-svg src="<?= $this->base('content:assets/icons/tree.svg') ?>" width="25" height="25"><canvas width="25" height="25"></canvas></kiss-svg>
            <a class="kiss-cover" href="<?= $this->route('/content/models/create') ?>?type=tree"></a>
        </kiss-card>
        <kiss-card class="kiss-padding kiss-position-relative kiss-color-primary@hover" kiss-tooltip="bottom" aria-label="<?= t('Singleton') ?>" theme="bordered" hover="bordered-primary">
            <kiss-svg src="<?= $this->base('content:assets/icons/singleton.svg') ?>" width="25" height="25"><canvas width="25" height="25"></canvas></kiss-svg>
            <a class="kiss-cover" href="<?= $this->route('/content/models/create') ?>?type=singleton"></a>
        </kiss-card>
    </kiss-grid>

<?php endif ?>

<?php $this->trigger('content.index.side-panel') ?>


<?php $this->end('app-side-panel') ?>
